/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.druid.client.cache.Cache;
import io.druid.query.SegmentDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.joda.time.Interval;

public class CacheUtil {
    public static Cache.NamedKey computeSegmentCacheKey(String segmentIdentifier, SegmentDescriptor descriptor, byte[] queryCacheKey) {
        Interval segmentQueryInterval = descriptor.getInterval();
        byte[] versionBytes = descriptor.getVersion().getBytes();
        return new Cache.NamedKey(segmentIdentifier, ByteBuffer.allocate(16 + versionBytes.length + 4 + queryCacheKey.length).putLong(segmentQueryInterval.getStartMillis()).putLong(segmentQueryInterval.getEndMillis()).put(versionBytes).putInt(descriptor.getPartitionNumber()).put(queryCacheKey).array());
    }

    public static void populate(Cache cache, ObjectMapper mapper, Cache.NamedKey key, Iterable<Object> results) {
        try {
            ArrayList bytes = Lists.newArrayList();
            int size = 0;
            for (Object result : results) {
                byte[] array = mapper.writeValueAsBytes(result);
                size += array.length;
                bytes.add(array);
            }
            byte[] valueBytes = new byte[size];
            int offset = 0;
            for (byte[] array : bytes) {
                System.arraycopy(array, 0, valueBytes, offset, array.length);
                offset += array.length;
            }
            cache.put(key, valueBytes);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

