/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidServer;
import io.druid.client.FilteredServerView;
import io.druid.client.ServerInventoryView;
import io.druid.client.ServerView;
import io.druid.guice.ManageLifecycle;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.curator.framework.CuratorFramework;

@ManageLifecycle
public class BatchServerInventoryView
extends ServerInventoryView<Set<DataSegment>>
implements FilteredServerView {
    private static final EmittingLogger log = new EmittingLogger(BatchServerInventoryView.class);
    private final ConcurrentMap<String, Set<DataSegment>> zNodes = new MapMaker().makeMap();
    private final ConcurrentMap<ServerView.SegmentCallback, Predicate<DataSegment>> segmentPredicates = new MapMaker().makeMap();
    private final Predicate<DataSegment> defaultFilter;

    @Inject
    public BatchServerInventoryView(ZkPathsConfig zkPaths, CuratorFramework curator, ObjectMapper jsonMapper, Predicate<DataSegment> defaultFilter) {
        super(log, zkPaths.getAnnouncementsPath(), zkPaths.getLiveSegmentsPath(), curator, jsonMapper, new TypeReference<Set<DataSegment>>(){});
        Preconditions.checkNotNull(defaultFilter);
        this.defaultFilter = defaultFilter;
    }

    @Override
    protected DruidServer addInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Predicate predicate = Predicates.or(this.defaultFilter, (Predicate)Predicates.or(this.segmentPredicates.values()));
        HashSet filteredInventory = Sets.newHashSet((Iterable)Iterables.filter(inventory, (Predicate)predicate));
        this.zNodes.put(inventoryKey, filteredInventory);
        for (DataSegment segment : filteredInventory) {
            this.addSingleInventory(container, segment);
        }
        return container;
    }

    @Override
    protected DruidServer updateInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Predicate predicate = Predicates.or(this.defaultFilter, (Predicate)Predicates.or(this.segmentPredicates.values()));
        HashSet filteredInventory = Sets.newHashSet((Iterable)Iterables.filter(inventory, (Predicate)predicate));
        Set existing = (Set)this.zNodes.get(inventoryKey);
        if (existing == null) {
            throw new ISE("Trying to update an inventoryKey[%s] that didn't exist?!", new Object[]{inventoryKey});
        }
        for (DataSegment segment : Sets.difference((Set)filteredInventory, (Set)existing)) {
            this.addSingleInventory(container, segment);
        }
        for (DataSegment segment : Sets.difference((Set)existing, (Set)filteredInventory)) {
            this.removeSingleInventory(container, segment.getIdentifier());
        }
        this.zNodes.put(inventoryKey, filteredInventory);
        return container;
    }

    @Override
    protected DruidServer removeInnerInventory(DruidServer container, String inventoryKey) {
        log.info("Server[%s] removed container[%s]", new Object[]{container.getName(), inventoryKey});
        Set segments = (Set)this.zNodes.remove(inventoryKey);
        if (segments == null) {
            log.warn("Told to remove container[%s], which didn't exist", new Object[]{inventoryKey});
            return container;
        }
        for (DataSegment segment : segments) {
            this.removeSingleInventory(container, segment.getIdentifier());
        }
        return container;
    }

    @Override
    public void registerSegmentCallback(Executor exec, final ServerView.SegmentCallback callback, final Predicate<DataSegment> filter) {
        this.segmentPredicates.put(callback, filter);
        this.registerSegmentCallback(exec, new ServerView.SegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                ServerView.CallbackAction action;
                if (filter.apply((Object)segment)) {
                    action = callback.segmentAdded(server, segment);
                    if (action.equals((Object)ServerView.CallbackAction.UNREGISTER)) {
                        BatchServerInventoryView.this.segmentPredicates.remove(callback);
                    }
                } else {
                    action = ServerView.CallbackAction.CONTINUE;
                }
                return action;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                ServerView.CallbackAction action;
                if (filter.apply((Object)segment)) {
                    action = callback.segmentRemoved(server, segment);
                    if (action.equals((Object)ServerView.CallbackAction.UNREGISTER)) {
                        BatchServerInventoryView.this.segmentPredicates.remove(callback);
                    }
                } else {
                    action = ServerView.CallbackAction.CONTINUE;
                }
                return action;
            }
        });
    }
}

