/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import io.druid.timeline.partition.PartitionChunk;

public class NumberedPartitionChunk<T>
implements PartitionChunk<T> {
    private final int chunkNumber;
    private final int chunks;
    private final T object;

    public static <T> NumberedPartitionChunk<T> make(int chunkNumber, int chunks, T obj) {
        return new NumberedPartitionChunk<T>(chunkNumber, chunks, obj);
    }

    public NumberedPartitionChunk(int chunkNumber, int chunks, T object) {
        Preconditions.checkArgument((chunkNumber >= 0 ? 1 : 0) != 0, (Object)"chunkNumber >= 0");
        Preconditions.checkArgument((chunkNumber < chunks ? 1 : 0) != 0, (Object)"chunkNumber < chunks");
        this.chunkNumber = chunkNumber;
        this.chunks = chunks;
        this.object = object;
    }

    public T getObject() {
        return this.object;
    }

    public boolean abuts(PartitionChunk<T> other) {
        return other instanceof NumberedPartitionChunk && other.getChunkNumber() == this.chunkNumber + 1;
    }

    public boolean isStart() {
        return this.chunkNumber == 0;
    }

    public boolean isEnd() {
        return this.chunkNumber == this.chunks - 1;
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public int compareTo(PartitionChunk<T> other) {
        if (other instanceof NumberedPartitionChunk) {
            NumberedPartitionChunk castedOther = (NumberedPartitionChunk)other;
            return ComparisonChain.start().compare(this.chunks, castedOther.chunks).compare(this.chunkNumber, castedOther.chunkNumber).result();
        }
        throw new IllegalArgumentException("Cannot compare against something that is not a NumberedPartitionChunk.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((NumberedPartitionChunk)o) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.chunks, this.chunkNumber});
    }
}

