/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.common.guava.Comparators;
import com.metamx.common.logger.Logger;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.partition.ImmutablePartitionHolder;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.PartitionHolder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class VersionedIntervalTimeline<VersionType, ObjectType> {
    private static final Logger log = new Logger(VersionedIntervalTimeline.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    final NavigableMap<Interval, TimelineEntry> completePartitionsTimeline = new TreeMap<Interval, TimelineEntry>(Comparators.intervalsByStartThenEnd());
    final NavigableMap<Interval, TimelineEntry> incompletePartitionsTimeline = new TreeMap<Interval, TimelineEntry>(Comparators.intervalsByStartThenEnd());
    private final Map<Interval, TreeMap<VersionType, TimelineEntry>> allTimelineEntries = Maps.newHashMap();
    private final Comparator<? super VersionType> versionComparator;

    public VersionedIntervalTimeline(Comparator<? super VersionType> versionComparator) {
        this.versionComparator = versionComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Interval interval, VersionType version, PartitionChunk<ObjectType> object) {
        try {
            this.lock.writeLock().lock();
            Map exists = this.allTimelineEntries.get(interval);
            TimelineEntry entry = null;
            if (exists == null) {
                entry = new TimelineEntry(interval, version, new PartitionHolder<ObjectType>(object));
                TreeMap<VersionType, TimelineEntry> versionEntry = new TreeMap<VersionType, TimelineEntry>(this.versionComparator);
                versionEntry.put(version, entry);
                this.allTimelineEntries.put(interval, versionEntry);
            } else {
                entry = (TimelineEntry)exists.get(version);
                if (entry == null) {
                    entry = new TimelineEntry(interval, version, new PartitionHolder<ObjectType>(object));
                    exists.put(version, entry);
                } else {
                    PartitionHolder partitionHolder = entry.getPartitionHolder();
                    partitionHolder.add(object);
                }
            }
            if (entry.getPartitionHolder().isComplete()) {
                this.add(this.completePartitionsTimeline, interval, entry);
            }
            this.add(this.incompletePartitionsTimeline, interval, entry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionChunk<ObjectType> remove(Interval interval, VersionType version, PartitionChunk<ObjectType> chunk) {
        try {
            this.lock.writeLock().lock();
            Map versionEntries = this.allTimelineEntries.get(interval);
            if (versionEntries == null) {
                PartitionChunk<ObjectType> partitionChunk = null;
                return partitionChunk;
            }
            TimelineEntry entry = (TimelineEntry)versionEntries.get(version);
            if (entry == null) {
                PartitionChunk<ObjectType> partitionChunk = null;
                return partitionChunk;
            }
            PartitionChunk retVal = entry.getPartitionHolder().remove(chunk);
            if (entry.getPartitionHolder().isEmpty()) {
                versionEntries.remove(version);
                if (versionEntries.isEmpty()) {
                    this.allTimelineEntries.remove(interval);
                }
                this.remove(this.incompletePartitionsTimeline, interval, entry, true);
            }
            this.remove(this.completePartitionsTimeline, interval, entry, false);
            PartitionChunk partitionChunk = retVal;
            return partitionChunk;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionHolder<ObjectType> findEntry(Interval interval, VersionType version) {
        try {
            this.lock.readLock().lock();
            for (Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>> entry : this.allTimelineEntries.entrySet()) {
                TimelineEntry foundEntry;
                if (!entry.getKey().equals((Object)interval) && !entry.getKey().contains((ReadableInterval)interval) || (foundEntry = entry.getValue().get(version)) == null) continue;
                ImmutablePartitionHolder immutablePartitionHolder = new ImmutablePartitionHolder(foundEntry.getPartitionHolder());
                return immutablePartitionHolder;
            }
            PartitionHolder<ObjectType> partitionHolder = null;
            return partitionHolder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TimelineObjectHolder<VersionType, ObjectType>> lookup(Interval interval) {
        try {
            this.lock.readLock().lock();
            List<TimelineObjectHolder<VersionType, ObjectType>> list = this.lookup(interval, false);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TimelineObjectHolder<VersionType, ObjectType>> findOvershadowed() {
        try {
            Map versionEntry;
            this.lock.readLock().lock();
            HashSet retVal = Sets.newHashSet();
            HashMap overShadowed = Maps.newHashMap();
            for (Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>> entry : this.allTimelineEntries.entrySet()) {
                HashMap versionCopy = Maps.newHashMap();
                versionCopy.putAll((Map)entry.getValue());
                overShadowed.put(entry.getKey(), versionCopy);
            }
            for (Map.Entry<Object, TreeMap<Object, TimelineEntry>> entry : this.completePartitionsTimeline.entrySet()) {
                versionEntry = (Map)overShadowed.get(((TimelineEntry)((Object)entry.getValue())).getTrueInterval());
                if (versionEntry == null) continue;
                versionEntry.remove(((TimelineEntry)((Object)entry.getValue())).getVersion());
                if (!versionEntry.isEmpty()) continue;
                overShadowed.remove(((TimelineEntry)((Object)entry.getValue())).getTrueInterval());
            }
            for (Map.Entry<Object, TreeMap<Object, TimelineEntry>> entry : this.incompletePartitionsTimeline.entrySet()) {
                versionEntry = (Map)overShadowed.get(((TimelineEntry)((Object)entry.getValue())).getTrueInterval());
                if (versionEntry == null) continue;
                versionEntry.remove(((TimelineEntry)((Object)entry.getValue())).getVersion());
                if (!versionEntry.isEmpty()) continue;
                overShadowed.remove(((TimelineEntry)((Object)entry.getValue())).getTrueInterval());
            }
            for (Map.Entry<Object, TreeMap<Object, TimelineEntry>> entry : overShadowed.entrySet()) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    TimelineEntry object = (TimelineEntry)entry2.getValue();
                    retVal.add(new TimelineObjectHolder(object.getTrueInterval(), object.getVersion(), object.getPartitionHolder()));
                }
            }
            HashSet hashSet = retVal;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void add(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, TimelineEntry entry) {
        TimelineEntry existsInTimeline = (TimelineEntry)timeline.get(interval);
        if (existsInTimeline != null) {
            int compare = this.versionComparator.compare(entry.getVersion(), existsInTimeline.getVersion());
            if (compare > 0) {
                this.addIntervalToTimeline(interval, entry, timeline);
            }
            return;
        }
        Interval lowerKey = timeline.lowerKey(interval);
        if (lowerKey != null && this.addAtKey(timeline, lowerKey, entry)) {
            return;
        }
        Interval higherKey = timeline.higherKey(interval);
        if (higherKey != null && this.addAtKey(timeline, higherKey, entry)) {
            return;
        }
        this.addIntervalToTimeline(interval, entry, timeline);
    }

    private boolean addAtKey(NavigableMap<Interval, TimelineEntry> timeline, Interval key, TimelineEntry entry) {
        boolean retVal = false;
        Interval currKey = key;
        Object entryInterval = entry.getTrueInterval();
        if (!currKey.overlaps((ReadableInterval)entryInterval)) {
            return false;
        }
        while (entryInterval != null && currKey != null && currKey.overlaps((ReadableInterval)entryInterval)) {
            Interval nextKey = timeline.higherKey(currKey);
            int versionCompare = this.versionComparator.compare(entry.getVersion(), ((TimelineEntry)timeline.get(currKey)).getVersion());
            if (versionCompare < 0) {
                if (currKey.contains((ReadableInterval)entryInterval)) {
                    return true;
                }
                if (currKey.getStart().isBefore((ReadableInstant)entryInterval.getStart())) {
                    entryInterval = new Interval((ReadableInstant)currKey.getEnd(), (ReadableInstant)entryInterval.getEnd());
                } else {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getStart(), (ReadableInstant)currKey.getStart()), entry, timeline);
                    entryInterval = entryInterval.getEnd().isAfter((ReadableInstant)currKey.getEnd()) ? new Interval((ReadableInstant)currKey.getEnd(), (ReadableInstant)entryInterval.getEnd()) : null;
                }
            } else if (versionCompare > 0) {
                TimelineEntry oldEntry = (TimelineEntry)timeline.remove(currKey);
                if (currKey.contains((ReadableInterval)entryInterval)) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)currKey.getStart(), (ReadableInstant)entryInterval.getStart()), oldEntry, timeline);
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getEnd(), (ReadableInstant)currKey.getEnd()), oldEntry, timeline);
                    this.addIntervalToTimeline((Interval)entryInterval, entry, timeline);
                    return true;
                }
                if (currKey.getStart().isBefore((ReadableInstant)entryInterval.getStart())) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)currKey.getStart(), (ReadableInstant)entryInterval.getStart()), oldEntry, timeline);
                } else if (entryInterval.getEnd().isBefore((ReadableInstant)currKey.getEnd())) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getEnd(), (ReadableInstant)currKey.getEnd()), oldEntry, timeline);
                }
            } else if (((TimelineEntry)timeline.get(currKey)).equals(entry)) {
                timeline.remove(currKey);
            } else {
                throw new UnsupportedOperationException(String.format("Cannot add overlapping segments [%s and %s] with the same version [%s]", currKey, entryInterval, entry.getVersion()));
            }
            currKey = nextKey;
            retVal = true;
        }
        this.addIntervalToTimeline((Interval)entryInterval, entry, timeline);
        return retVal;
    }

    private void addIntervalToTimeline(Interval interval, TimelineEntry entry, NavigableMap<Interval, TimelineEntry> timeline) {
        if (interval != null && interval.toDurationMillis() > 0L) {
            timeline.put(interval, entry);
        }
    }

    private void remove(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, TimelineEntry entry, boolean incompleteOk) {
        ArrayList intervalsToRemove = Lists.newArrayList();
        TimelineEntry removed = (TimelineEntry)timeline.get(interval);
        if (removed == null) {
            for (Map.Entry timelineEntry : timeline.entrySet()) {
                if (timelineEntry.getValue() != entry) continue;
                intervalsToRemove.add(timelineEntry.getKey());
            }
        } else {
            intervalsToRemove.add(interval);
        }
        for (Interval i : intervalsToRemove) {
            this.remove(timeline, i, incompleteOk);
        }
    }

    private void remove(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, boolean incompleteOk) {
        timeline.remove(interval);
        for (Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>> versionEntry : this.allTimelineEntries.entrySet()) {
            TimelineEntry timelineEntry;
            if (versionEntry.getKey().overlap((ReadableInterval)interval) == null || !(timelineEntry = versionEntry.getValue().lastEntry().getValue()).getPartitionHolder().isComplete() && !incompleteOk) continue;
            this.add(timeline, versionEntry.getKey(), timelineEntry);
        }
    }

    private List<TimelineObjectHolder<VersionType, ObjectType>> lookup(Interval interval, boolean incompleteOk) {
        TimelineObjectHolder lastEntry;
        ArrayList<TimelineObjectHolder<VersionType, ObjectType>> retVal = new ArrayList<TimelineObjectHolder<VersionType, ObjectType>>();
        NavigableMap<Interval, TimelineEntry> timeline = incompleteOk ? this.incompletePartitionsTimeline : this.completePartitionsTimeline;
        for (Map.Entry entry : timeline.entrySet()) {
            Interval timelineInterval = (Interval)entry.getKey();
            TimelineEntry val = (TimelineEntry)entry.getValue();
            if (!timelineInterval.overlaps((ReadableInterval)interval)) continue;
            retVal.add(new TimelineObjectHolder(timelineInterval, val.getVersion(), val.getPartitionHolder()));
        }
        if (retVal.isEmpty()) {
            return retVal;
        }
        TimelineObjectHolder firstEntry = (TimelineObjectHolder)retVal.get(0);
        if (interval.overlaps((ReadableInterval)firstEntry.getInterval()) && interval.getStart().isAfter((ReadableInstant)firstEntry.getInterval().getStart())) {
            retVal.set(0, new TimelineObjectHolder(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)firstEntry.getInterval().getEnd()), firstEntry.getVersion(), firstEntry.getObject()));
        }
        if (interval.overlaps((ReadableInterval)(lastEntry = (TimelineObjectHolder)retVal.get(retVal.size() - 1)).getInterval()) && interval.getEnd().isBefore((ReadableInstant)lastEntry.getInterval().getEnd())) {
            retVal.set(retVal.size() - 1, new TimelineObjectHolder(new Interval((ReadableInstant)lastEntry.getInterval().getStart(), (ReadableInstant)interval.getEnd()), lastEntry.getVersion(), lastEntry.getObject()));
        }
        return retVal;
    }

    public static void main(String[] args) {
        System.out.println(new Interval((ReadableInstant)new DateTime(), (ReadableInstant)((DateTime)null)));
    }

    public class TimelineEntry {
        private final Interval trueInterval;
        private final VersionType version;
        private final PartitionHolder<ObjectType> partitionHolder;

        public TimelineEntry(Interval trueInterval, VersionType version, PartitionHolder<ObjectType> partitionHolder) {
            this.trueInterval = trueInterval;
            this.version = version;
            this.partitionHolder = partitionHolder;
        }

        public Interval getTrueInterval() {
            return this.trueInterval;
        }

        public VersionType getVersion() {
            return this.version;
        }

        public PartitionHolder<ObjectType> getPartitionHolder() {
            return this.partitionHolder;
        }
    }
}

