/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class ListProvider<T>
implements Provider<List<T>> {
    private final List<Key<? extends T>> itemsToLoad = Lists.newArrayList();
    private Injector injector;

    public ListProvider<T> add(Class<? extends T> clazz) {
        return this.add(Key.get(clazz));
    }

    public ListProvider<T> add(Class<? extends T> clazz, Class<? extends Annotation> annotation) {
        return this.add(Key.get(clazz, annotation));
    }

    public ListProvider<T> add(Class<? extends T> clazz, Annotation annotation) {
        return this.add(Key.get(clazz, (Annotation)annotation));
    }

    public ListProvider<T> add(Key<? extends T> key) {
        this.itemsToLoad.add(key);
        return this;
    }

    @Inject
    private void configure(Injector injector) {
        this.injector = injector;
    }

    public List<T> get() {
        ArrayList retVal = Lists.newArrayListWithExpectedSize((int)this.itemsToLoad.size());
        for (Key<? extends T> key : this.itemsToLoad) {
            retVal.add(this.injector.getInstance(key));
        }
        return retVal;
    }
}

