/*
 * Decompiled with CFR 0.152.
 */
package io.druid.db;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class DbTablesConfig {
    private static String defaultBase = "druid";
    @JsonProperty(value="base")
    private final String base;
    @JsonProperty(value="segments")
    private final String segmentsTable;
    @JsonProperty(value="rules")
    private final String rulesTable;
    @JsonProperty(value="config")
    private final String configTable;
    @JsonProperty(value="tasks")
    private final String tasksTable;
    @JsonProperty(value="taskLog")
    private final String taskLogTable;
    @JsonProperty(value="taskLock")
    private final String taskLockTable;

    public static DbTablesConfig fromBase(String base) {
        return new DbTablesConfig(base, null, null, null, null, null, null);
    }

    @JsonCreator
    public DbTablesConfig(@JsonProperty(value="base") String base, @JsonProperty(value="segments") String segmentsTable, @JsonProperty(value="rules") String rulesTable, @JsonProperty(value="config") String configTable, @JsonProperty(value="tasks") String tasksTable, @JsonProperty(value="taskLog") String taskLogTable, @JsonProperty(value="taskLock") String taskLockTable) {
        this.base = base == null ? defaultBase : base;
        this.segmentsTable = this.makeTableName(segmentsTable, "segments");
        this.rulesTable = this.makeTableName(rulesTable, "rules");
        this.configTable = this.makeTableName(configTable, "config");
        this.tasksTable = this.makeTableName(tasksTable, "tasks");
        this.taskLogTable = this.makeTableName(taskLogTable, "tasklogs");
        this.taskLockTable = this.makeTableName(taskLockTable, "tasklocks");
    }

    private String makeTableName(String explicitTableName, String defaultSuffix) {
        if (explicitTableName == null) {
            if (this.base == null) {
                return null;
            }
            return String.format("%s_%s", this.base, defaultSuffix);
        }
        return explicitTableName;
    }

    public String getBase() {
        return this.base;
    }

    public String getSegmentsTable() {
        return this.segmentsTable;
    }

    public String getRulesTable() {
        return this.rulesTable;
    }

    public String getConfigTable() {
        return this.configTable;
    }

    public String getTasksTable() {
        return this.tasksTable;
    }

    public String getTaskLogTable() {
        return this.taskLogTable;
    }

    public String getTaskLockTable() {
        return this.taskLockTable;
    }
}

