/*
 * Decompiled with CFR 0.152.
 */
package io.druid.db;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.db.DbConnectorConfig;
import io.druid.db.DbTablesConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class DbConnector {
    private static final Logger log = new Logger(DbConnector.class);
    private final Supplier<DbConnectorConfig> config;
    private final Supplier<DbTablesConfig> dbTables;
    private final DBI dbi;
    private boolean isPostgreSQL = false;

    public static void createSegmentTable(IDBI dbi, String segmentTableName, boolean isPostgreSQL) {
        DbConnector.createTable(dbi, segmentTableName, String.format(isPostgreSQL ? "CREATE TABLE %1$s (id VARCHAR(255) NOT NULL, dataSource VARCHAR(255) NOT NULL, created_date TEXT NOT NULL, start TEXT NOT NULL, \"end\" TEXT NOT NULL, partitioned SMALLINT NOT NULL, version TEXT NOT NULL, used BOOLEAN NOT NULL, payload bytea NOT NULL, PRIMARY KEY (id));CREATE INDEX ON %1$s(dataSource);CREATE INDEX ON %1$s(used);" : "CREATE table %s (id VARCHAR(255) NOT NULL, dataSource VARCHAR(255) NOT NULL, created_date TINYTEXT NOT NULL, start TINYTEXT NOT NULL, end TINYTEXT NOT NULL, partitioned BOOLEAN NOT NULL, version TINYTEXT NOT NULL, used BOOLEAN NOT NULL, payload LONGTEXT NOT NULL, INDEX(dataSource), INDEX(used), PRIMARY KEY (id))", segmentTableName), isPostgreSQL);
    }

    public static void createRuleTable(IDBI dbi, String ruleTableName, boolean isPostgreSQL) {
        DbConnector.createTable(dbi, ruleTableName, String.format(isPostgreSQL ? "CREATE TABLE %1$s (id VARCHAR(255) NOT NULL, dataSource VARCHAR(255) NOT NULL, version TEXT NOT NULL, payload bytea NOT NULL, PRIMARY KEY (id));CREATE INDEX ON %1$s(dataSource);" : "CREATE table %s (id VARCHAR(255) NOT NULL, dataSource VARCHAR(255) NOT NULL, version TINYTEXT NOT NULL, payload LONGTEXT NOT NULL, INDEX(dataSource), PRIMARY KEY (id))", ruleTableName), isPostgreSQL);
    }

    public static void createConfigTable(IDBI dbi, String configTableName, boolean isPostgreSQL) {
        DbConnector.createTable(dbi, configTableName, String.format(isPostgreSQL ? "CREATE TABLE %s (name VARCHAR(255) NOT NULL, payload bytea NOT NULL, PRIMARY KEY(name))" : "CREATE table %s (name VARCHAR(255) NOT NULL, payload BLOB NOT NULL, PRIMARY KEY(name))", configTableName), isPostgreSQL);
    }

    public static void createTaskTable(IDBI dbi, String taskTableName, boolean isPostgreSQL) {
        DbConnector.createTable(dbi, taskTableName, String.format(isPostgreSQL ? "CREATE TABLE %1$s (\n  id varchar(255) NOT NULL,\n  created_date TEXT NOT NULL,\n  datasource varchar(255) NOT NULL,\n  payload bytea NOT NULL,\n  status_payload bytea NOT NULL,\n  active SMALLINT NOT NULL DEFAULT '0',\n  PRIMARY KEY (id)\n);\nCREATE INDEX ON %1$s(active, created_date);" : "CREATE TABLE `%s` (\n  `id` varchar(255) NOT NULL,\n  `created_date` tinytext NOT NULL,\n  `datasource` varchar(255) NOT NULL,\n  `payload` longblob NOT NULL,\n  `status_payload` longblob NOT NULL,\n  `active` tinyint(1) NOT NULL DEFAULT '0',\n  PRIMARY KEY (`id`),\n  KEY (active, created_date(100))\n)", taskTableName), isPostgreSQL);
    }

    public static void createTaskLogTable(IDBI dbi, String taskLogsTableName, boolean isPostgreSQL) {
        DbConnector.createTable(dbi, taskLogsTableName, String.format(isPostgreSQL ? "CREATE TABLE %1$s (\n  id bigserial NOT NULL,\n  task_id varchar(255) DEFAULT NULL,\n  log_payload bytea,\n  PRIMARY KEY (id)\n);\nCREATE INDEX ON %1$s(task_id);" : "CREATE TABLE `%s` (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\n  `task_id` varchar(255) DEFAULT NULL,\n  `log_payload` longblob,\n  PRIMARY KEY (`id`),\n  KEY `task_id` (`task_id`)\n)", taskLogsTableName), isPostgreSQL);
    }

    public static void createTaskLockTable(IDBI dbi, String taskLocksTableName, boolean isPostgreSQL) {
        DbConnector.createTable(dbi, taskLocksTableName, String.format(isPostgreSQL ? "CREATE TABLE %1$s (\n  id bigserial NOT NULL,\n  task_id varchar(255) DEFAULT NULL,\n  lock_payload bytea,\n  PRIMARY KEY (id)\n);\nCREATE INDEX ON %1$s(task_id);" : "CREATE TABLE `%s` (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\n  `task_id` varchar(255) DEFAULT NULL,\n  `lock_payload` longblob,\n  PRIMARY KEY (`id`),\n  KEY `task_id` (`task_id`)\n)", taskLocksTableName), isPostgreSQL);
    }

    public static void createTable(IDBI dbi, final String tableName, final String sql, final boolean isPostgreSQL) {
        try {
            dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    List table = isPostgreSQL ? handle.select(String.format("SELECT tablename FROM pg_catalog.pg_tables WHERE schemaname = 'public' AND tablename LIKE '%s'", tableName), new Object[0]) : handle.select(String.format("SHOW tables LIKE '%s'", tableName), new Object[0]);
                    if (table.isEmpty()) {
                        log.info("Creating table[%s]", new Object[]{tableName});
                        handle.createStatement(sql).execute();
                    } else {
                        log.info("Table[%s] existed: [%s]", new Object[]{tableName, table});
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception creating table", new Object[0]);
        }
    }

    public Void insertOrUpdate(String tableName, String keyColumn, String valueColumn, final String key, final byte[] value) throws SQLException {
        final String insertOrUpdateStatement = String.format(this.isPostgreSQL ? "BEGIN;\nLOCK TABLE %1$s IN SHARE ROW EXCLUSIVE MODE;\nWITH upsert AS (UPDATE %1$s SET %3$s=:value WHERE %2$s=:key RETURNING *)\n    INSERT INTO %1$s (%2$s, %3$s) SELECT :key, :value WHERE NOT EXISTS (SELECT * FROM upsert)\n;COMMIT;" : "INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value) ON DUPLICATE KEY UPDATE %3$s = :value", tableName, keyColumn, valueColumn);
        return (Void)this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                ((Update)((Update)handle.createStatement(insertOrUpdateStatement).bind("key", key)).bind("value", value)).execute();
                return null;
            }
        });
    }

    public byte[] lookup(String tableName, String keyColumn, final String valueColumn, final String key) {
        final String selectStatement = String.format("SELECT %s FROM %s WHERE %s = :key", valueColumn, tableName, keyColumn);
        return (byte[])this.dbi.withHandle((HandleCallback)new HandleCallback<byte[]>(){

            public byte[] withHandle(Handle handle) throws Exception {
                List matched = ((Query)handle.createQuery(selectStatement).bind("key", key)).map((ResultSetMapper)new ResultSetMapper<byte[]>(){

                    public byte[] map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        return r.getBytes(valueColumn);
                    }
                }).list();
                if (matched.isEmpty()) {
                    return null;
                }
                if (matched.size() > 1) {
                    throw new ISE("Error! More than one matching entry[%d] found for [%s]?!", new Object[]{matched.size(), key});
                }
                return (byte[])matched.get(0);
            }
        });
    }

    public static Boolean isPostgreSQL(IDBI dbi) {
        return (Boolean)dbi.withHandle((HandleCallback)new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return DbConnector.isPostgreSQL(handle);
            }
        });
    }

    protected static Boolean isPostgreSQL(Handle handle) throws SQLException {
        return handle.getConnection().getMetaData().getDatabaseProductName().contains("PostgreSQL");
    }

    @Inject
    public DbConnector(Supplier<DbConnectorConfig> config, Supplier<DbTablesConfig> dbTables) {
        this.config = config;
        this.dbTables = dbTables;
        this.dbi = new DBI(this.getDatasource());
    }

    public DBI getDBI() {
        return this.dbi;
    }

    public boolean isPostgreSQL() {
        return this.isPostgreSQL;
    }

    private DataSource getDatasource() {
        DbConnectorConfig connectorConfig = (DbConnectorConfig)this.config.get();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(connectorConfig.getUser());
        dataSource.setPassword(connectorConfig.getPassword());
        String uri = connectorConfig.getConnectURI();
        this.isPostgreSQL = uri.startsWith("jdbc:postgresql");
        dataSource.setUrl(uri);
        if (connectorConfig.isUseValidationQuery()) {
            dataSource.setValidationQuery(connectorConfig.getValidationQuery());
            dataSource.setTestOnBorrow(true);
        }
        return dataSource;
    }

    public void createSegmentTable() {
        if (((DbConnectorConfig)this.config.get()).isCreateTables()) {
            DbConnector.createSegmentTable((IDBI)this.dbi, ((DbTablesConfig)this.dbTables.get()).getSegmentsTable(), this.isPostgreSQL);
        }
    }

    public void createRulesTable() {
        if (((DbConnectorConfig)this.config.get()).isCreateTables()) {
            DbConnector.createRuleTable((IDBI)this.dbi, ((DbTablesConfig)this.dbTables.get()).getRulesTable(), this.isPostgreSQL);
        }
    }

    public void createConfigTable() {
        if (((DbConnectorConfig)this.config.get()).isCreateTables()) {
            DbConnector.createConfigTable((IDBI)this.dbi, ((DbTablesConfig)this.dbTables.get()).getConfigTable(), this.isPostgreSQL);
        }
    }

    public void createTaskTables() {
        if (((DbConnectorConfig)this.config.get()).isCreateTables()) {
            DbTablesConfig dbTablesConfig = (DbTablesConfig)this.dbTables.get();
            DbConnector.createTaskTable((IDBI)this.dbi, dbTablesConfig.getTasksTable(), this.isPostgreSQL);
            DbConnector.createTaskLogTable((IDBI)this.dbi, dbTablesConfig.getTaskLogTable(), this.isPostgreSQL);
            DbConnector.createTaskLockTable((IDBI)this.dbi, dbTablesConfig.getTaskLockTable(), this.isPostgreSQL);
        }
    }
}

