/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.guava.Comparators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class JodaUtils {
    public static ArrayList<Interval> condenseIntervals(Iterable<Interval> intervals) {
        ArrayList retVal = Lists.newArrayList();
        TreeSet sortedIntervals = Sets.newTreeSet((Comparator)Comparators.intervalsByStartThenEnd());
        for (Interval interval : intervals) {
            sortedIntervals.add(interval);
        }
        if (sortedIntervals.isEmpty()) {
            return Lists.newArrayList();
        }
        Iterator intervalsIter = sortedIntervals.iterator();
        Interval currInterval = (Interval)intervalsIter.next();
        while (intervalsIter.hasNext()) {
            Interval next = (Interval)intervalsIter.next();
            if (currInterval.overlaps((ReadableInterval)next) || currInterval.abuts((ReadableInterval)next)) {
                currInterval = new Interval((ReadableInstant)currInterval.getStart(), (ReadableInstant)next.getEnd());
                continue;
            }
            retVal.add(currInterval);
            currInterval = next;
        }
        retVal.add(currInterval);
        return retVal;
    }

    public static Interval umbrellaInterval(Iterable<Interval> intervals) {
        ArrayList startDates = Lists.newArrayList();
        ArrayList endDates = Lists.newArrayList();
        for (Interval interval : intervals) {
            startDates.add(interval.getStart());
            endDates.add(interval.getEnd());
        }
        DateTime minStart = JodaUtils.minDateTime(startDates.toArray(new DateTime[0]));
        DateTime maxEnd = JodaUtils.maxDateTime(endDates.toArray(new DateTime[0]));
        if (minStart == null || maxEnd == null) {
            throw new IllegalArgumentException("Empty list of intervals");
        }
        return new Interval((ReadableInstant)minStart, (ReadableInstant)maxEnd);
    }

    public static boolean overlaps(final Interval i, Iterable<Interval> intervals) {
        return Iterables.any(intervals, (Predicate)new Predicate<Interval>(){

            public boolean apply(@Nullable Interval input) {
                return input.overlaps((ReadableInterval)i);
            }
        });
    }

    public static DateTime minDateTime(DateTime ... times) {
        if (times == null) {
            return null;
        }
        switch (times.length) {
            case 0: {
                return null;
            }
            case 1: {
                return times[0];
            }
        }
        DateTime min = times[0];
        for (int i = 1; i < times.length; ++i) {
            min = min.isBefore((ReadableInstant)times[i]) ? min : times[i];
        }
        return min;
    }

    public static DateTime maxDateTime(DateTime ... times) {
        if (times == null) {
            return null;
        }
        switch (times.length) {
            case 0: {
                return null;
            }
            case 1: {
                return times[0];
            }
        }
        DateTime max = times[0];
        for (int i = 1; i < times.length; ++i) {
            max = max.isAfter((ReadableInstant)times[i]) ? max : times[i];
        }
        return max;
    }
}

