/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.guava;

import com.google.common.collect.Ordering;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.Yielders;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.common.guava.nary.BinaryFn;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public class CombiningSequence<T>
implements Sequence<T> {
    private final Sequence<T> baseSequence;
    private final Ordering<T> ordering;
    private final BinaryFn<T, T, T> mergeFn;

    public static <T> CombiningSequence<T> create(Sequence<T> baseSequence, Ordering<T> ordering, BinaryFn<T, T, T> mergeFn) {
        return new CombiningSequence<T>(baseSequence, ordering, mergeFn);
    }

    public CombiningSequence(Sequence<T> baseSequence, Ordering<T> ordering, BinaryFn<T, T, T> mergeFn) {
        this.baseSequence = baseSequence;
        this.ordering = ordering;
        this.mergeFn = mergeFn;
    }

    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
        AtomicReference<OutType> retVal = new AtomicReference<OutType>(initValue);
        CombiningAccumulator<OutType> combiningAccumulator = new CombiningAccumulator<OutType>(retVal, accumulator);
        Object lastValue = this.baseSequence.accumulate(null, combiningAccumulator);
        return (OutType)(combiningAccumulator.accumulatedSomething() ? accumulator.accumulate(retVal.get(), lastValue) : initValue);
    }

    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        CombiningYieldingAccumulator<OutType, T> combiningAccumulator = new CombiningYieldingAccumulator<OutType, T>(this.ordering, this.mergeFn, accumulator);
        combiningAccumulator.setRetVal(initValue);
        Yielder baseYielder = this.baseSequence.toYielder(null, combiningAccumulator);
        return this.makeYielder(baseYielder, combiningAccumulator, false);
    }

    public <OutType, T> Yielder<OutType> makeYielder(Yielder<T> yielder, final CombiningYieldingAccumulator<OutType, T> combiningAccumulator, boolean finalValue) {
        boolean finalFinalValue;
        Yielder finalYielder;
        OutType retVal;
        if (!yielder.isDone()) {
            retVal = combiningAccumulator.getRetVal();
            finalYielder = yielder.next(yielder.get());
            finalFinalValue = false;
        } else if (!finalValue && combiningAccumulator.accumulatedSomething()) {
            combiningAccumulator.accumulateLastValue();
            retVal = combiningAccumulator.getRetVal();
            finalFinalValue = true;
            if (!combiningAccumulator.yielded()) {
                return Yielders.done(null, yielder);
            }
            finalYielder = Yielders.done(null, yielder);
        } else {
            return Yielders.done(null, yielder);
        }
        return new Yielder<OutType>(){

            public OutType get() {
                return retVal;
            }

            public Yielder<OutType> next(OutType initValue) {
                return CombiningSequence.this.makeYielder(finalYielder, combiningAccumulator, finalFinalValue);
            }

            public boolean isDone() {
                return false;
            }

            public void close() throws IOException {
                finalYielder.close();
            }
        };
    }

    private class CombiningAccumulator<OutType>
    implements Accumulator<T, T> {
        private final AtomicReference<OutType> retVal;
        private final Accumulator<OutType, T> accumulator;
        private volatile boolean accumulatedSomething = false;

        public CombiningAccumulator(AtomicReference<OutType> retVal, Accumulator<OutType, T> accumulator) {
            this.retVal = retVal;
            this.accumulator = accumulator;
        }

        public boolean accumulatedSomething() {
            return this.accumulatedSomething;
        }

        public T accumulate(T prevValue, T t) {
            if (!this.accumulatedSomething) {
                this.accumulatedSomething = true;
            }
            if (prevValue == null) {
                return CombiningSequence.this.mergeFn.apply(t, null);
            }
            if (CombiningSequence.this.ordering.compare(prevValue, t) == 0) {
                return CombiningSequence.this.mergeFn.apply(prevValue, t);
            }
            this.retVal.set(this.accumulator.accumulate(this.retVal.get(), prevValue));
            return t;
        }
    }

    private static class CombiningYieldingAccumulator<OutType, T>
    extends YieldingAccumulator<T, T> {
        private final Ordering<T> ordering;
        private final BinaryFn<T, T, T> mergeFn;
        private final YieldingAccumulator<OutType, T> accumulator;
        private volatile OutType retVal;
        private volatile T lastMergedVal;
        private volatile boolean accumulatedSomething = false;

        public CombiningYieldingAccumulator(Ordering<T> ordering, BinaryFn<T, T, T> mergeFn, YieldingAccumulator<OutType, T> accumulator) {
            this.ordering = ordering;
            this.mergeFn = mergeFn;
            this.accumulator = accumulator;
        }

        public OutType getRetVal() {
            return this.retVal;
        }

        public void setRetVal(OutType retVal) {
            this.retVal = retVal;
        }

        public YieldingAccumulator<OutType, T> getAccumulator() {
            return this.accumulator;
        }

        public void reset() {
            this.accumulator.reset();
        }

        public boolean yielded() {
            return this.accumulator.yielded();
        }

        public void yield() {
            this.accumulator.yield();
        }

        public T accumulate(T prevValue, T t) {
            if (!this.accumulatedSomething) {
                this.accumulatedSomething = true;
            }
            if (prevValue == null) {
                this.lastMergedVal = this.mergeFn.apply(t, null);
                return this.lastMergedVal;
            }
            if (this.ordering.compare(prevValue, t) == 0) {
                this.lastMergedVal = this.mergeFn.apply(prevValue, t);
                return this.lastMergedVal;
            }
            this.lastMergedVal = t;
            this.retVal = this.accumulator.accumulate(this.retVal, prevValue);
            return t;
        }

        public void accumulateLastValue() {
            this.retVal = this.accumulator.accumulate(this.retVal, this.lastMergedVal);
        }

        public boolean accumulatedSomething() {
            return this.accumulatedSomething;
        }
    }
}

