/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.common.config.ConfigManager;
import io.druid.common.config.ConfigSerde;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public class JacksonConfigManager {
    private final ConfigManager configManager;
    private final ObjectMapper jsonMapper;

    @Inject
    public JacksonConfigManager(ConfigManager configManager, ObjectMapper jsonMapper) {
        this.configManager = configManager;
        this.jsonMapper = jsonMapper;
    }

    public <T> AtomicReference<T> watch(String key, Class<? extends T> clazz) {
        return this.watch(key, clazz, null);
    }

    public <T> AtomicReference<T> watch(String key, Class<? extends T> clazz, T defaultVal) {
        return this.configManager.watchConfig(key, this.create(clazz, defaultVal));
    }

    public <T> AtomicReference<T> watch(String key, TypeReference<T> clazz) {
        return this.watch(key, clazz, null);
    }

    public <T> AtomicReference<T> watch(String key, TypeReference<T> clazz, T defaultVal) {
        return this.configManager.watchConfig(key, this.create(clazz, defaultVal));
    }

    public <T> boolean set(String key, T val) {
        return this.configManager.set(key, this.create(val.getClass(), null), val);
    }

    private <T> ConfigSerde<T> create(final Class<? extends T> clazz, final T defaultVal) {
        return new ConfigSerde<T>(){

            @Override
            public byte[] serialize(T obj) {
                try {
                    return JacksonConfigManager.this.jsonMapper.writeValueAsBytes(obj);
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public T deserialize(byte[] bytes) {
                if (bytes == null) {
                    return defaultVal;
                }
                try {
                    return JacksonConfigManager.this.jsonMapper.readValue(bytes, clazz);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    private <T> ConfigSerde<T> create(final TypeReference<? extends T> clazz, final T defaultVal) {
        return new ConfigSerde<T>(){

            @Override
            public byte[] serialize(T obj) {
                try {
                    return JacksonConfigManager.this.jsonMapper.writeValueAsBytes(obj);
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public T deserialize(byte[] bytes) {
                if (bytes == null) {
                    return defaultVal;
                }
                try {
                    return JacksonConfigManager.this.jsonMapper.readValue(bytes, clazz);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }
}

